IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_SNGPC_SAIDA_PERDA_NF]') 
					)

CREATE TABLE [dbo].[EST_SNGPC_SAIDA_PERDA_NF] (
  [CD_SAI_SNGPC] int NOT NULL,
  [CD_EMP] int NOT NULL,
  [CD_FILIAL] int NOT NULL,
  [CD_NF] int NOT NULL,
  [CD_PROD] int NOT NULL,
  [CD_IT] int NOT NULL,
  CONSTRAINT [PK__EST_SNGP__F17E63EA41CB9EF9] PRIMARY KEY CLUSTERED ([CD_SAI_SNGPC]),
  CONSTRAINT [EST_SNGPC_SAIDA_PERDA_NF_fk] FOREIGN KEY ([CD_SAI_SNGPC]) 
  REFERENCES [dbo].[EST_SNGPC_SAIDA] ([CD_SAI_SNGPC]) 
  ON UPDATE NO ACTION
  ON DELETE CASCADE,
  CONSTRAINT [EST_SNGPC_SAIDA_PERDA_NF_FK_NF] FOREIGN KEY ([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD], [CD_IT]) 
  REFERENCES [dbo].[EST_NF_SAI_IT] ([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD], [CD_IT]) 
  ON UPDATE NO ACTION
  ON DELETE CASCADE
)
ON [PRIMARY]
GO

-- SADA TRANSFERNCIA
CREATE TRIGGER [dbo].[TRG_EST_SNGPC_SAIDA_PERDA_NF_EXCLUSAO] ON [dbo].[EST_SNGPC_SAIDA_PERDA_NF]
WITH EXECUTE AS CALLER
FOR INSERT, UPDATE, DELETE
AS
BEGIN

	-- VERIFICA A QUANTIDADE J INSERIDA E A QUANTIDADE CANCELADA
	DECLARE @QTDE INTEGER;
	DECLARE @QTDECANCEL INTEGER;

	SET @QTDE = (
		SELECT
			COALESCE(SUM(A.QT_LOTE), 0)
		FROM
			EST_SNGPC_SAIDA A
			INNER JOIN EST_SNGPC_SAIDA_PERDA_NF B ON
				A.CD_SAI_SNGPC = B.CD_SAI_SNGPC				
			INNER JOIN INSERTED I ON
				B.CD_EMP        = I.CD_EMP
				AND B.CD_FILIAL = I.CD_FILIAL
				AND B.CD_NF     = I.CD_NF
				AND B.CD_PROD   = I.CD_PROD
				AND B.CD_IT     = I.CD_IT
	);

	SET @QTDECANCEL = (
		SELECT
			COALESCE(SUM(A.QT_CANCEL), 0)
		FROM
			EST_NF_SAI_IT_EST_SNGPC_PENDENTE_CANCELADO A
			INNER JOIN INSERTED I ON
				A.CD_EMP        = I.CD_EMP
				AND A.CD_FILIAL = I.CD_FILIAL
				AND A.CD_NF     = I.CD_NF
				AND A.CD_PROD   = I.CD_PROD
				AND A.CD_IT     = I.CD_IT
	);

	-- VERIFICA SE A QUANTIDADE INSERIDA BATE COM A QUANTIDADE DA VENDA
	IF EXISTS (
		SELECT 
			A.QT_IT
		FROM
			EST_NF_SAI_IT A
			INNER JOIN INSERTED I ON
				A.CD_EMP        = I.CD_EMP
				AND A.CD_FILIAL = I.CD_FILIAL
				AND A.CD_NF     = I.CD_NF
				AND A.CD_PROD   = I.CD_PROD
				AND A.CD_IT     = I.CD_IT
		WHERE
			(A.QT_IT - @QTDECANCEL) = @QTDE
	)
		BEGIN
			-- REMOVE A PENDNCIA DE SADA NO SNGPC
			DELETE 
					E
			FROM 
				EST_NF_SAI_IT_EST_SNGPC_PENDENTE E 
				INNER JOIN INSERTED I ON
					E.CD_EMP        = I.CD_EMP
					AND E.CD_FILIAL = I.CD_FILIAL
					AND E.CD_NF     = I.CD_NF
					AND E.CD_PROD   = I.CD_PROD
					AND E.CD_IT     = I.CD_IT;
		END

	ELSE
		BEGIN
			-- VERIFICA SE A PENDNCIA AINDA EXISTE
			IF NOT EXISTS (
				SELECT 
					A.CD_EMP
				FROM
					EST_NF_SAI_IT_EST_SNGPC_PENDENTE A
					INNER JOIN DELETED D ON
						A.CD_EMP        = D.CD_EMP
						AND A.CD_FILIAL = D.CD_FILIAL
						AND A.CD_NF     = D.CD_NF
						AND A.CD_PROD   = D.CD_PROD
						AND A.CD_IT     = D.CD_IT
				)
				BEGIN
					-- INSERE A PENDNCIA NOVAMENTE
					INSERT INTO EST_NF_SAI_IT_EST_SNGPC_PENDENTE
						SELECT 
							CD_EMP, 
							CD_FILIAL,
							CD_NF,
							CD_PROD,
							CD_IT,
							GETDATE()
						FROM 
							DELETED;
				END;
		END;
END
GO